from poisson_deconvolution.microscopy.moment_estimator import (
    StdMicroscopyMomentEstimator,
)
from poisson_deconvolution.moment_estimator.complex_moment_approximator import (
    ComplexNormMomentApproximator,
)
from poisson_deconvolution.microscopy import MicroscopyExperiment


class NormMicroscopyMomentEstimator(StdMicroscopyMomentEstimator):
    """
    Class for estimating moments and atoms in microscopy experiments.
    """

    atoms = None

    def __init__(
        self, experiment: MicroscopyExperiment, max_atoms: int, scale: float, **kwargs
    ):
        """
        Initialize the NormMicroscopyMomentEstimator.

        Parameters:
        - experiment (MicroscopyExperiment): The microscopy experiment object.
        - max_atoms (int): The maximum number of atoms to consider.
        - scale (float): The scale of Gaussian distribution (kernel).
        """
        super().__init__(experiment, max_atoms, **kwargs)
        self.moment_estimator = ComplexNormMomentApproximator(max_atoms, scale)
